<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flight Seat Map</title>
    <style>
        /* Add your CSS styles here */
        /* Styles for modal and seat map */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }

        .modal-content {
            background-color: #fefefe;
            margin: 10% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 400px; /* Adjust the maximum width as needed */
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .seat {
            margin: 5px;
            display: inline-block;
            width: 30px;
            height: 30px;
            background-color: #ddd;
            border: 1px solid #ccc;
            border-radius: 5px;
            position: relative;
            cursor: pointer;
        }

        .seat input {
            display: none;
        }

        .seat label {
            display: block;
            width: 100%;
            height: 100%;
        }

        .seat input:checked + label {
            background-color: #4CAF50; /* Green for selected seats */
            color: white;
        }

        .seat label::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 12px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

<!-- Your main content goes here -->

<!-- Button to open the seat map modal -->
<button id="openSeatMapBtn">Open Seat Map</button>

<!-- The seat map modal -->
<div id="seatMapModal" class="modal">
    <div class="modal-content">
        <!-- Close button for the modal -->
        <span class="close" onclick="closeSeatMapModal()">&times;</span>

        <!-- Seat map content -->
        <h2>Flight Seat Map</h2>
        <div id="seatMapContainer">
            <!-- Seat map grid and seats will be dynamically generated here -->
            <?php
                $rows = 15;
                $columns = 7;
                $alphabet = range('A', 'Z');

                echo '<div>';
                echo '<div class="seat"></div>'; // Empty cell in the top-left corner
                for ($col = 1; $col <= $columns; $col++) {
                    echo '<div class="seat">' . $alphabet[$col - 1] . '</div>';
                }
                echo '</div>';

                for ($row = 1; $row <= $rows; $row++) {
                    echo '<div>';
                    echo '<div class="seat">' . $row . '</div>';
                    for ($col = 1; $col <= $columns; $col++) {
                        $seatNumber = ($row - 1) * $columns + $col;
                        $seatName = $row . $alphabet[$col - 1];
                        echo '<div class="seat"><input type="radio" id="seat' . $seatNumber . '" name="seat" value="' . $seatNumber . '"><label for="seat' . $seatNumber . '">' . $seatName . '</label></div>';
                    }
                    echo '</div>';
                }
            ?>
        </div>
    </div>
</div>

<!-- Your other scripts go here -->

<!-- Script to handle modal interactions -->
<script>
    // Get references to modal elements
    var seatMapModal = document.getElementById('seatMapModal');
    var openSeatMapBtn = document.getElementById('openSeatMapBtn');

    // Function to open the seat map modal
    function openSeatMapModal() {
        seatMapModal.style.display = 'block';
        // Additional logic to dynamically generate seat map content goes here
    }

    // Function to close the seat map modal
    function closeSeatMapModal() {
        seatMapModal.style.display = 'none';
    }

    // Event listener for the open seat map button
    openSeatMapBtn.addEventListener('click', openSeatMapModal);
</script>

</body>
</html>
