<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Home extends MY_Frontend_Controller
{
     public function __construct()
    {

        parent::__construct();
        $this->load->helper("url");
        $this->load->library("pagination");
    }

    public function index()
    {
        $data['title']    = 'Home';
        $data['city_list']    = $this->db->get('city_info')->result();
        $this->load->view('front/index' , $data);
    }
    public function searchFlights()
    {
        $data['title']    = 'Flights';
        $data['city_list']    = $this->db->get('city_info')->result();
        if($_POST){
            
        
        $origin = $this->input->post('origin');
        $destination = $this->input->post('destination');
        if (isset($_SESSION['post_search_data'])) {
        $this->session->unset_userdata('post_search_data');
        }
        $data['from_city_name'] =  $this->db->get_where('city_info', array('code' => $origin))->row()->name;
        $data['to_city_name'] = $this->db->get_where('city_info', array('code' => $destination))->row()->name;
        
        $travel_date = $this->input->post('depart_date');
        $travel_date = date('d-m-Y',strtotime($travel_date));
        $adult = $this->input->post('onewayAdult');
        $child = $this->input->post('onewayChild');
        $infant = $this->input->post('onewayInfant');
        $class = $this->input->post('class');
        if($adult == 0 && $child == 0){
        $adult='1';    
        }if($class==''){
           $class ='Economy'; 
        }
        $data['filters']=$this->input->post();
        $direct_flight=true;
        $connection_flight=true;
        if($this->input->post('non_stop')){    
        $connection_flight=false;    
        }
        $search_data = [
          "searchQuery" => [
            "cabinClass" => $class,
            "paxInfo"    => [
                 "ADULT"    => $adult,
                 "CHILD"    => $child,
                 "INFANT"   => $infant
             ],
            "routeInfos"  => [array(
                 "fromCityOrAirport" => array(
                 "code"           => $origin
                 ),
            "toCityOrAirport"  => array(
                 "code"           => $destination    
                ),
            "travelDate" => $travel_date 
           )],
        "searchModifiers" => array(
        "isDirectFlight" => $direct_flight,
        "isConnectingFlight" => $connection_flight
    )]];
        $method ='POST';
        $url = 'https://apitest.tripjack.com/fms/v1/air-search-all';
        $result = $this->callAPI($method, $url, $search_data);
        $data['flight_search'] = $result;
         // $decoded= json_decode($result);
       // print_r(json_decode($result));die();
        
       $postData = $this->input->post();
       $this->session->set_userdata('post_search_data', $postData);
       $storedPostData = $this->session->userdata('post_search_data');
        if(!empty($storedPostData)){
        $data['flight_details'] = $result;
        $this->load->view('front/flight-listing-oneway' , $data);   
        }else{
        $this->load->view('front/search_expire_modal' , $data);    
        } 
       }else{
        $this->load->view('front/search_expire_modal' , $data);    
       }
    }
    public function flight_details()
    {
       $id = $this->input->post('fare_id');
       $data['title']    = 'Flight Details'; 
        $search_data = array(
          "priceIds" =>[$id]
            );
        $method ='POST';
        $url = 'https://apitest.tripjack.com/fms/v1/review';
        $result = $this->callAPI($method, $url, $search_data);
        //print_r($result);die();
        $data['selected_priceId'] = $id;
        $flight_det = json_decode($result); 
        if(isset($flight_det->tripInfos[0])){
        $data['flight_details'] = $result;
        $this->load->view('front/flight-details' , $data);    
        }else{
        $this->load->view('front/search_expire_modal' , $data);    
        }
        
    }
    public function pax_details($bookingId,$priceId)
    {
       $data['title']    = 'Pax Details'; 
       //flight details 
         $search_data1 = array(
          "priceIds" =>[$priceId]
            );
        //$this->book($bookingId);
        $method ='POST';
        $url = 'https://apitest.tripjack.com/fms/v1/review';
        $result1 = $this->callAPI($method, $url, $search_data1);
        $data['selected_priceId'] = $priceId;
        $flight_det = json_decode($result1); 
        //die(print_r(json_decode($result1)));
        if(isset($flight_det->tripInfos[0])){
        $data['flight_details'] = $result1; 
        
        
        $search_data2 = array(
          "bookingId" =>$bookingId
            );
        $method ='POST';
        $url = 'https://apitest.tripjack.com/fms/v1/seat';
        $result2 = $this->callAPI($method, $url, $search_data2);
         $response =   json_decode($result2);
        if (isset($response->status->success) && $response->status->success === false) {
            $data['error_msg'] =  $response->errors[0]->message;
            $data['seat_map_info'] =array();
       } else {
        $data['seat_map_info'] = $result2;
        }    
        //$data['seat_map_info'] = $result2;
            
       // die(print_r(json_decode($result1)));
       $this->load->view('front/traveller-details' , $data); 
        }else{
         $this->load->view('front/search_expire_modal' , $data);   
        }
    }
    
    public function book($bookingId)
    { 
  
     $booking_data =[
         "bookingId" =>$bookingId,
         "paymentInfos" => [
             "amount"=>52254
         ],
         "travellerInfo" =>[
            array(
            "ti" =>"MR",
            "fN" =>"Yogesh",
            "lN"=>"Sharma",
             "pt"=>"ADULT"
                
            ),
             "ssrBaggageInfos" =>[
             
             array(
                "key"=>"880",
                 "code"=>"XC05" 
             ),
             array(
                "key"=>"882",
                 "code"=>"XC05"   
                 ),
             ],
             "ssrMealInfos" =>[
             
             array(
                "key"=>"880",
                 "code"=>"SWVG" 
             ),
             array(
                "key"=>"881",
                 "code"=>"SWVG"   
                 ),
            array(
                "key"=>"882",
                 "code"=>"SWVG"   
                 ),
             ],
             "ssrSeatInfos" =>[
             
             array(
                "key"=>"880",
                 "code"=>"3A" 
             ),
             array(
                "key"=>"881",
                 "code"=>"3D"   
                 ),
            array(
                "key"=>"882",
                 "code"=>"3D"   
                 ),
             ],
             
            ],
        "deliveryInfo" =>[
           "emails"=>["yogesh.sharma@roinet.in"], 
           "contacts"=>["+918840939402"], 
        ]    
       ];
      $method ='POST';
        $url = 'https://tripjack.com/oms/v1/air/book';
        $result2 = $this->callAPI($method, $url, $booking_data);
         $response =   json_decode($result2);
   print_r($response);
        
        
    }
    function callAPI($method, $url, $data){
        
    $data = json_encode($data);
        $curl = curl_init();
        switch ($method){
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            default:
                if ($data)
                    $curl = sprintf("%s?%s", $curl, http_build_query($data));
        }
        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'apikey: 8122703e80a456-35b9-49c7-b5c2-c924704db927',
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // EXECUTE
        $result = curl_exec($curl);
        if(!$result){
            die("Connection Failure");
        }
        curl_close($curl);
       // print_r($result);
        return $result;
    }
    public function test()
    {
        $this->load->view('front/test'); 
    }
  /*  public function about_us()
    {
        $data['title']    = 'About Us';
        $data['welcome']    = $this->db->get('welcome')->row();
        $data['why_choose_us']    = $this->db->get('why_choose_us')->result();
        $data['about_us']    = $this->db->get('about_us')->row();
        $this->load->view('front/about-us' , $data);
    }
    public function course($slug)
    {
        $prep = $data['prep_category'] = $this->db->get_where('prepare_category', array('slug' => $slug))->row();
        $course = $data['course_det'] = $this->db->get_where('course_page', array('category' => $prep->id))->row();
         
        $data['title']    = $course->title;
        $this->load->view('front/course_details' , $data);
    }
    public function acca_on_demand()
    {
        $data['title']    = 'ACCA On-Demand';
        $this->load->view('front/acca_on_demand' , $data);  
    }
    public function media()
    {
        $data['title']    = 'Photo Gallery';
        $data['gallery']    = $this->db->get_where('gallery', array('type' => '0'))->result();
        $data['gallery_banner']    = $this->db->get_where('gallery', array('type' => '1'))->row();
        $this->load->view('front/media' , $data);
    }
    public function affiliation()
    {
        $data['title']    = 'Affiliations';
        $data['auth']    = $this->db->get_where('certifications', array('name' => 'Authorised Test Center For'))->result();
        $data['learn']    = $this->db->get_where('certifications', array('name' => 'Learning Provider'))->result();
        $this->load->view('front/affiliation' , $data);
    }
    public function offers()
    {
        
        $data['offers'] = $this->db->get('offers')->result(); 
        $data['title']    = 'Offers';
        $this->load->view('front/offers' , $data);
    }*/
  /*  public function courses($para1='')
    {
        $data['certifications']    = $this->db->get('certifications')->result();
        if(!empty($para1)) {
        if($para1 == 'dm_pro') {
        $data['title']    = 'DM-PRO || Courses';     
        }elseif($para1 == 'dm_specialist') {  
        $data['title']    = 'DM-Specialist || Courses';
        }
        $this->load->view('front/'.$para1 , $data);    
        } else {
        $data['title']    = 'Courses';
        $this->load->view('front/courses.php' , $data);    
        }  
    }
     public function blogsingle($id='')
    {
        $data['title']    = 'Blog';
        if(!empty($id)){
        $data['blog'] = $this->db->get_where('blogs', array('status' => '1','id' => $id))->row();  
        $this->load->view('front/blog-single.php' , $data);    
        }
    }
     public function blogs($id='')
    {
        $data['title']    = 'Blog';
        $config = array();
 
        $config["base_url"] = base_url() . "Home/blogs";
 
        $config["total_rows"] = $this->crud_model->blog_record_count();
 
        $config["per_page"] = 3;
 
        $config["uri_segment"] = 3;
        $config["full_tag_open"] = '<ul class="pagination">';
        $config["full_tag_close"] = '</ul>';	

        $config["first_link"] = "&laquo;";
        $config["first_tag_open"] = "<li>";
        $config["first_tag_close"] = "</li>";

        $config["last_link"] = "&raquo;";
        $config["last_tag_open"] = "<li>";
        $config["last_tag_close"] = "</li>";

        $config['next_link'] = '&gt;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '<li>';

        $config['prev_link'] = '&lt;';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '<li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
 
        $this->pagination->initialize($config);
 
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
 
        $data["blogs"] = $this->crud_model->fetch_blogs($config["per_page"], $page);
 
        $data["links"] = $this->pagination->create_links();
        $data["title"] = "Blog"; 
        $this->load->view("front/blog.php", $data);
    }
    public function gallery()
    {
        $data['title']    = 'Gallery';
        $data['gallery']    = $this->db->get('gallery')->result();
        $this->load->view('front/gallery.php' , $data);
    }
    public function contact()
    {
        $data['title']    = 'Contact Us';
        $this->load->view('front/contact.php' , $data);
    }
     public function faq()
    {
        $data['title']    = 'FAQ';
        $this->load->view('front/faq.php' , $data);
    }
     public function privacy_policy()
    {
        $data['title']    = 'Privacy Policy';
        $this->load->view('front/privacy-policy.php' , $data);
    }
     public function terms_conditions()
    {
        $data['title']    = 'Terms & Conditions';
        $this->load->view('front/terms-conditions.php' , $data);
    }
    public function site_map()
    {
        header("Content-type: text/xml");
        $xml_file = file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/edu-codeyaya/application/views/front/sitemap.xml");
        echo $xml_file;
    }
    
    public function contact_us()
    {
        if($_POST){
        $comments = array(
            'name'     => $this->input->post('name'),
            'email'    => $this->input->post('email'),
            'phone'     => $this->input->post('phone'),
            'message'  => $this->input->post('comments'),
            'date_created'       => time(),
        );  
            if(!empty($comments['name']) && !empty($comments['email']) && !empty($comments['phone']) && !empty($comments['message'])) $this->db->insert('contact_us', $comments);
          redirect($_SERVER['HTTP_REFERER']);   
        }
    }
    public function download_brochure()
    {
        if($_POST){
        $brochure = array(
            'first_name'     => $this->input->post('first_name'),
            'email'    => $this->input->post('email'),
            'date_created'       => time(),
        );  
        if(!empty($this->input->post('last_name'))) $brochure['last_name'] = $this->input->post('last_name'); 
        if(!empty($this->input->post('phone'))) $brochure['phone'] = $this->input->post('phone');
        if(!empty($brochure['first_name']) || !empty($brochure['email'])) 
        $res = $this->db->insert('download_brochure', $brochure);
        if($res) { 
        $brochure_file = $this->db->get_where('business_profile', array('id'=>'1'))->row()->brochure;
        $this->load->helper('download');
        force_download('./uploads/front/brochure/'.$brochure_file, NULL);
        }
        redirect($_SERVER['HTTP_REFERER']);   
        }
    }
    function file_download()
    {
        $brochure = $this->db->get_where('business_profile', array('id'=>'1'))->row()->brochure;
        $this->load->helper('download');
        force_download('./uploads/front/brochure/'.$brochure, NULL);
}
    public function call_back()
    {
        if($_POST){
        $data = array(
            'phone'     => $this->input->post('number'),
            'date_created'       => time(),
        );  
            if(!empty($data['phone'])) $this->db->insert('call_back', $data);
         redirect($_SERVER['HTTP_REFERER']);   
        }
    }*/
     public function contact()
    {
        $data['title']    = 'Contact Us';
        $this->load->view('front/contact-us' , $data);
    }
     public function contact_us()
    {
        if($_POST){
            
          $name  = $this->input->post('name');
          $email = $this->input->post('email');
          $phone = $this->input->post('phone');
          $sub = $this->input->post('subject');
          $message = $this->input->post('message');
        $comments = array(
            'name'     => $name,
            'email'    => $email,
            'phone'     => $phone,
            'subject'     => $sub,
            'message'  => $message,
            'date_created'       => time(),
        );  
            if(!empty($comments['name']) && !empty($comments['email']) && !empty($comments['phone']) && !empty($comments['message'])) $this->db->insert('contact_us', $comments);
         // redirect($_SERVER['HTTP_REFERER']); 
            
            //send email
           /* $config['protocol'] = "smtp";
            $config['smtp_host'] = "ssl://smtp.googlemail.com";
            $config['smtp_port'] = "465";
            $config['smtp_user'] = "jassim@cassol.org";
            $config['smtp_pass'] = "mygamilpassword";
            $subject = 'CASSOL - Contacts';
            $message = "Category: $subject \n Name: $name \n Email: $email \n Phone: $phone \n Subject: $sub \n Message: $message";

            $config['mailtype'] = "html";
            $ci = & get_instance();
            $ci->load->library('email', $config);
            $ci->email->set_newline("\r\n");
            $ci->email->from($email);
            $ci->email->to("jassim@cassol.org");
            $ci->email->subject($subject);
            $ci->email->message($message);
            $ci->email->send();  */
            //echo $this->email->print_debugger();
            
            
             echo 'Thank You! We will be in touch soon';
        }
    }
    public function application()
    {
        if($_POST){
            $name   = $this->input->post('full_name');
            $email  = $this->input->post('email');
            $phone  = $this->input->post('phone');
            $course = $this->input->post('course');
        $data = array(
            'name'     => $name,
            'email'     => $email,
            'phone'     => $phone,
            'course'     => $course
        );  
            if(!empty($data['phone'])) $this->db->insert('applications', $data);
            
            //send email
            $config['protocol'] = "smtp";
            $config['smtp_host'] = "ssl://smtp.googlemail.com";
            $config['smtp_port'] = "465";
            $config['smtp_user'] = "jassim@cassol.org";
            $config['smtp_pass'] = "mygamilpassword";
            $subject = 'CASSOL - Enquiries';
            $message = "Category: $subject \n Name: $name \n Email: $email \n Phone: $phone \n Course: $course";

            $config['mailtype'] = "html";
            $ci = & get_instance();
            $ci->load->library('email', $config);
            $ci->email->set_newline("\r\n");
            $ci->email->from($email);
            $ci->email->to("jassim@cassol.org");
            $ci->email->subject($subject);
            $ci->email->message($message);
            $ci->email->send();  
            //echo $this->email->print_debugger();
            
            
             echo 'Thank You! We will be in touch soon';
           // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Thank you for applying</div>');
           // redirect($_SERVER['HTTP_REFERER']);    
        }
    }
    public function send_acca_enquiry()
    {
        if($_POST){
            $name   = $this->input->post('full_name');
            $email  = $this->input->post('email');
            $phone  = $this->input->post('phone');
            $test = $this->input->post('test_name');
            $note = $this->input->post('note');
            $date = $this->input->post('date');
        $data = array(
            'name'     => $name,
            'email'     => $email,
            'phone'     => $phone,
            'test_name'     => $test,
            'message'     => $note,
            'date'     => $date
        );  
            if(!empty($data['phone'])) $this->db->insert('acca_enquiry', $data);
            
            //send email
            /*$config['protocol'] = "smtp";
            $config['smtp_host'] = "ssl://smtp.googlemail.com";
            $config['smtp_port'] = "465";
            $config['smtp_user'] = "jassim@cassol.org";
            $config['smtp_pass'] = "mygamilpassword";
            $subject = 'CASSOL - Take a test';
            $message = "Category: $subject \n Name: $name \n Email: $email \n Phone: $phone \n Test Name: $test \n Date: $date \n Message: $note";

            $config['mailtype'] = "html";
            $ci = & get_instance();
            $ci->load->library('email', $config);
            $ci->email->set_newline("\r\n");
            $ci->email->from($email);
            $ci->email->to("jassim@cassol.org");
            $ci->email->subject($subject);
            $ci->email->message($message);
            $ci->email->send();*/  
            //echo $this->email->print_debugger();
            
            
             echo 'Thank You! We will be in touch soon';
           // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Thank you for applying</div>');
           // redirect($_SERVER['HTTP_REFERER']);    
        }
    } 
}
